/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.block.component;

import com.technicalitiesmc.lib.block.BlockComponent;
import com.technicalitiesmc.lib.block.BlockComponentData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Contract;

public class BlockCapabilities
extends BlockComponent.WithData<Data> {
    private final Map<Capability<?>, CapabilityInfo<?>> providers;
    private final boolean shouldAutoInvalidate;

    private BlockCapabilities(BlockComponent.Context context, Map<Capability<?>, CapabilityInfo<?>> providers) {
        super(context, Data::new);
        this.providers = providers;
        this.shouldAutoInvalidate = providers.values().stream().anyMatch(CapabilityInfo::autoInvalidate);
    }

    public static Builder of() {
        return new Builder();
    }

    public void invalidate(Level level, BlockPos pos, BlockState state, Capability<?> capability) {
        Data data = (Data)this.getData((BlockGetter)level, pos, state);
        if (data == null) {
            return;
        }
        Map<Direction, LazyOptional<?>> cache = data.capabilities.remove(capability);
        if (cache != null) {
            cache.values().forEach(LazyOptional::invalidate);
        }
    }

    @Override
    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moving) {
        Data data;
        if (newState.m_60713_(state.m_60734_()) && (data = (Data)this.getData((BlockGetter)level, pos, state)) != null) {
            ArrayList<Capability> toRemove = new ArrayList<Capability>();
            data.capabilities.forEach((cap, values) -> {
                CapabilityInfo<?> info = this.providers.get(cap);
                for (Property<?> property : info.invalidatingProperties()) {
                    if (state.m_61143_(property).equals(newState.m_61143_(property))) continue;
                    toRemove.add((Capability)cap);
                    values.values().forEach(LazyOptional::invalidate);
                    break;
                }
            });
            toRemove.forEach(data.capabilities::remove);
        }
    }

    public static class Builder
    implements BlockComponent.Constructor<BlockCapabilities> {
        private final Map<Capability<?>, CapabilityInfo<?>> providers = new IdentityHashMap();

        @Contract(value="_, _, _, _ -> this")
        public <T> Builder with(Capability<T> capability, Provider<T> provider, boolean autoInvalidate, Property<?> ... invalidatingProperties) {
            this.providers.put(capability, new CapabilityInfo<T>(provider, autoInvalidate, invalidatingProperties));
            return this;
        }

        @Contract(value="_, _, _ -> this")
        public <T> Builder withManaged(Capability<T> capability, ManagedProvider<T> provider, Property<?> ... invalidatingProperties) {
            return this.with(capability, provider, true, invalidatingProperties);
        }

        @Override
        public BlockCapabilities create(BlockComponent.Context context) {
            return new BlockCapabilities(context, this.providers);
        }
    }

    public static class Data
    extends BlockComponentData<BlockCapabilities> {
        private final Map<Capability<?>, Map<Direction, LazyOptional<?>>> capabilities = new IdentityHashMap();
        private final List<LazyOptional<?>> toInvalidate;

        private Data(BlockComponentData.Context context) {
            super(context);
            this.toInvalidate = ((BlockCapabilities)this.getComponent()).shouldAutoInvalidate ? new ArrayList() : null;
        }

        @Override
        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            LazyOptional<?> cached;
            Map<Direction, LazyOptional<?>> cachedMap = this.capabilities.get(cap);
            if (cachedMap != null && ((cached = cachedMap.get(side)) == LazyOptional.empty() || cached != null && cached.isPresent())) {
                return cached.cast();
            }
            CapabilityInfo<?> info = ((BlockCapabilities)this.getComponent()).providers.get(cap);
            if (info == null) {
                return LazyOptional.empty();
            }
            Map map = this.capabilities.computeIfAbsent(cap, $ -> new HashMap());
            LazyOptional<?> value = info.provider().getCapability(this.getLevel(), this.getBlockPos(), this.getBlockState(), side);
            map.put(side, value);
            if (info.autoInvalidate()) {
                this.toInvalidate.add(value);
            }
            return value.cast();
        }

        @Override
        public void invalidateCaps() {
            if (this.toInvalidate != null) {
                this.toInvalidate.forEach(LazyOptional::invalidate);
            }
        }
    }

    private record CapabilityInfo<T>(Provider<T> provider, boolean autoInvalidate, Property<?>[] invalidatingProperties) {
    }

    @FunctionalInterface
    public static interface ManagedProvider<T>
    extends Provider<T> {
        @Nullable
        public T get(Level var1, BlockPos var2, BlockState var3, @Nullable Direction var4);

        @Override
        default public LazyOptional<T> getCapability(Level level, BlockPos pos, BlockState state, @Nullable Direction side) {
            Object value = this.get(level, pos, state, side);
            return value == null ? LazyOptional.empty() : LazyOptional.of(() -> value);
        }
    }

    @FunctionalInterface
    public static interface Provider<T> {
        public LazyOptional<T> getCapability(Level var1, BlockPos var2, BlockState var3, @Nullable Direction var4);
    }
}

